<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
    exit;
}

// Retrieve and validate input data
$banner_id = $_POST['banner_id'] ?? null;
$redirect_link = $_POST['redirect_link'] ?? null;
$position = $_POST['position'] ?? null;
$active = $_POST['active'] ?? null;

if (!$banner_id) {
    echo json_encode(["status" => "error", "message" => "Banner ID is required"]);
    exit;
}

// Initialize file paths
$imageDir = 'images/banner/';
$webImagePath = null;
$mobileImagePath = null;
$tabImagePath = null;

// Handle file uploads
if (!empty($_FILES['web_image']['name'])) {
    $webImagePath = $imageDir . basename($_FILES['web_image']['name']);
    if (!move_uploaded_file($_FILES['web_image']['tmp_name'], $webImagePath)) {
        echo json_encode(["status" => "error", "message" => "Failed to upload web image"]);
        exit;
    }
}

if (!empty($_FILES['mobile_banner']['name'])) {
    $mobileImagePath = $imageDir . basename($_FILES['mobile_banner']['name']);
    if (!move_uploaded_file($_FILES['mobile_banner']['tmp_name'], $mobileImagePath)) {
        echo json_encode(["status" => "error", "message" => "Failed to upload mobile banner"]);
        exit;
    }
}

if (!empty($_FILES['tab_banner']['name'])) {
    $tabImagePath = $imageDir . basename($_FILES['tab_banner']['name']);
    if (!move_uploaded_file($_FILES['tab_banner']['tmp_name'], $tabImagePath)) {
        echo json_encode(["status" => "error", "message" => "Failed to upload tab banner"]);
        exit;
    }
}

// Build the update query dynamically
$updateFields = [];

if ($redirect_link) {
    $updateFields[] = "Redircet_link = '" . mysqli_real_escape_string($conn, $redirect_link) . "'";
}

if ($position !== null) {
    $updateFields[] = "position = " . intval($position);
}

if ($active !== null) {
    $updateFields[] = "active = " . intval($active);
}

if ($webImagePath) {
    $updateFields[] = "Web_Image = '" . mysqli_real_escape_string($conn, $webImagePath) . "'";
}

if ($mobileImagePath) {
    $updateFields[] = "Mobile_banner = '" . mysqli_real_escape_string($conn, $mobileImagePath) . "'";
}

if ($tabImagePath) {
    $updateFields[] = "Tab_banner = '" . mysqli_real_escape_string($conn, $tabImagePath) . "'";
}

if (empty($updateFields)) {
    echo json_encode(["status" => "error", "message" => "No data provided for update"]);
    exit;
}

$updateQuery = "UPDATE banner SET " . implode(", ", $updateFields) . " WHERE banner_id = '" . mysqli_real_escape_string($conn, $banner_id) . "'";

// Execute the update query
if (mysqli_query($conn, $updateQuery)) {
    echo json_encode(["status" => "success", "message" => "Banner updated successfully"]);
} else {
    echo json_encode(["status" => "error", "message" => "Failed to update banner"]);
}
?>
